/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.Random;

public class Main {
    private static final int NUM_SORTS = 5;
    private static final int DEFAULT_ID = 303;
    private static final Random random = new Random();

    private Main() {
    }

    public static void main(String[] stringArray) {
        long l;
        int[] nArray;
        if (stringArray.length != 2 || stringArray[0].length() != 1) {
            System.err.println("usage: java -jar MysterySort.jar sort_id filename");
            return;
        }
        int n = Character.toUpperCase(stringArray[0].charAt(0)) - 65;
        if (n < 0 || n >= 5) {
            System.err.println("sort_id must be between A and " + (char)(65 + n - 1));
            return;
        }
        int n2 = Main.mapTrial(n);
        try {
            nArray = Main.readNumbers(stringArray[1]);
        }
        catch (IOException iOException) {
            System.err.println("Error reading file: " + iOException.getMessage());
            return;
        }
        Main.doSort(n2, new int[]{4, 6, 3, 2, 5, 7, 1, 0});
        int n3 = 0;
        int[] nArray2 = new int[nArray.length];
        long l2 = System.currentTimeMillis();
        do {
            System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
            Main.doSort(n2, nArray2);
            ++n3;
        } while ((l = System.currentTimeMillis() - l2) < 1000L);
        Arrays.sort(nArray);
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray2[i] == nArray[i]) continue;
            System.err.println("out of order at index " + i);
            return;
        }
        System.out.printf("%10.3fms%6c%8d%10d %s\n", (double)l / (double)n3, n + 65, nArray.length, n3, n3 == 1 ? "trial" : "trials");
    }

    private static int mapTrial(int n) {
        int n2 = 303;
        int n3 = n2 % 4 + 1;
        int n4 = n2 + (n2 >> 3);
        int n5 = 2;
        while (n5 < n3) {
            if (n3 % n5 == 0 && 5 % n5 == 0) {
                n3 /= n5;
                continue;
            }
            ++n5;
        }
        return (n3 * n + n4) % 5;
    }

    private static void doSort(int n, int[] nArray) {
        switch (n) {
            case 0: {
                Main.sortF(nArray);
                break;
            }
            case 1: {
                Main.sortB(nArray);
                break;
            }
            case 2: {
                Main.sortC(nArray);
                break;
            }
            case 3: {
                Main.sortD(nArray);
                break;
            }
            case 4: {
                Main.sortE(nArray);
            }
        }
    }

    private static int[] readNumbers(String string) throws IOException {
        Object object;
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
        int n = 0;
        int[] nArray = new int[16];
        while ((object = bufferedReader.readLine()) != null) {
            try {
                int n2 = Integer.parseInt(((String)object).trim());
                if (n >= nArray.length) {
                    int[] nArray2 = new int[2 * nArray.length];
                    System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
                    nArray = nArray2;
                }
                nArray[n] = n2;
                ++n;
            }
            catch (NumberFormatException numberFormatException) {
                throw new IOException("Unrecognized integer on line " + (n + 1));
            }
        }
        bufferedReader.close();
        if (n == nArray.length) {
            return nArray;
        }
        object = new int[n];
        System.arraycopy(nArray, 0, object, 0, n);
        return object;
    }

    private static void sortD(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            int n;
            int n2 = i;
            for (n = i + 1; n < nArray.length; ++n) {
                if (nArray[n] >= nArray[n2]) continue;
                n2 = n;
            }
            n = nArray[n2];
            nArray[n2] = nArray[i];
            nArray[i] = n;
        }
    }

    private static void sortB(int[] nArray) {
        for (int i = 1; i < nArray.length; ++i) {
            int n = nArray[i];
            for (int j = i - 1; j >= 0 && nArray[j] > n; --j) {
                nArray[j + 1] = nArray[j];
            }
            nArray[j + 1] = n;
        }
    }

    private static void sortE(int[] nArray) {
        int[] nArray2 = new int[nArray.length];
        int[] nArray3 = nArray;
        for (int i = 1; i < nArray.length; i *= 2) {
            for (int j = 0; j < nArray.length; j += 2 * i) {
                int n = j + i;
                if (n >= nArray3.length) {
                    System.arraycopy(nArray3, j, nArray2, j, nArray3.length - j);
                    continue;
                }
                int n2 = n + i;
                if (n2 > nArray3.length) {
                    n2 = nArray3.length;
                }
                Main.sortESub(nArray2, nArray3, n - i, n, n2);
            }
            int[] nArray4 = nArray2;
            nArray2 = nArray3;
            nArray3 = nArray4;
        }
        if (nArray3 != nArray) {
            System.arraycopy(nArray3, 0, nArray, 0, nArray.length);
        }
    }

    private static void sortESub(int[] nArray, int[] nArray2, int n, int n2, int n3) {
        int n4 = n;
        int n5 = n2;
        int n6 = n;
        while (n4 < n2 && n5 < n3) {
            if (nArray2[n4] < nArray2[n5]) {
                nArray[n6] = nArray2[n4];
                ++n4;
                ++n6;
                continue;
            }
            nArray[n6] = nArray2[n5];
            ++n5;
            ++n6;
        }
        while (n4 < n2) {
            nArray[n6] = nArray2[n4];
            ++n4;
            ++n6;
        }
        while (n5 < n3) {
            nArray[n6] = nArray2[n5];
            ++n5;
            ++n6;
        }
    }

    private static void sortF(int[] nArray) {
        Main.sortFSub(nArray, 0, nArray.length);
    }

    private static void sortFSub(int[] nArray, int n, int n2) {
        if (n2 - n >= 2) {
            int n3 = Main.partition(nArray, n, n2, n + random.nextInt(n2 - n));
            Main.sortFSub(nArray, n, n3);
            Main.sortFSub(nArray, n3 + 1, n2);
        }
    }

    private static void sortC(int[] nArray) {
        Main.sortCSub(nArray, 0, nArray.length);
    }

    private static void sortCSub(int[] nArray, int n, int n2) {
        if (n2 - n >= 2) {
            int n3 = Main.partition(nArray, n, n2, (n + n2) / 2);
            Main.sortCSub(nArray, n, n3);
            Main.sortCSub(nArray, n3 + 1, n2);
        }
    }

    private static int partition(int[] nArray, int n, int n2, int n3) {
        int n4 = nArray[n3];
        nArray[n3] = nArray[n];
        nArray[n] = n4;
        int n5 = n + 1;
        int n6 = n2 - 1;
        while (n5 <= n6) {
            if (nArray[n5] <= n4) {
                ++n5;
                continue;
            }
            if (nArray[n6] >= n4) {
                --n6;
                continue;
            }
            int n7 = nArray[n5];
            nArray[n5] = nArray[n6];
            nArray[n6] = n7;
            ++n5;
            --n6;
        }
        nArray[n] = nArray[n5 - 1];
        nArray[n5 - 1] = n4;
        return n5 - 1;
    }

    private static void sortA(int[] nArray) {
        int n;
        int n2;
        int n3;
        int n4 = nArray.length;
        for (int i = (n4 - 2) / 2; i >= 0; --i) {
            n3 = i;
            n2 = nArray[n3];
            while ((n = 2 * n3 + 1) < n4) {
                if (n + 1 < n4 && nArray[n + 1] > nArray[n]) {
                    ++n;
                }
                if (n2 > nArray[n]) break;
                nArray[n3] = nArray[n];
                n3 = n;
            }
            nArray[n3] = n2;
        }
        while (n4 > 1) {
            int n5;
            n3 = nArray[0];
            n2 = 0;
            n = nArray[n4 - 1];
            while ((n5 = 2 * n2 + 1) < n4) {
                if (n5 + 1 < n4 && nArray[n5 + 1] > nArray[n5]) {
                    ++n5;
                }
                if (n > nArray[n5]) break;
                nArray[n2] = nArray[n5];
                n2 = n5;
            }
            nArray[n2] = n;
            nArray[--n4] = n3;
        }
    }
}

