/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics;

public class LongWall
implements Surface {
    private double x;
    private double y0;
    private double y1;
    private Texture texture;

    public LongWall(double d, double d2, double d3, Texture texture) {
        this.x = d;
        this.y0 = Math.min(d2, d3);
        this.y1 = Math.max(d2, d3);
        this.texture = texture;
    }

    public String toString() {
        return "LongWall[" + this.x + "," + this.y0 + "-" + this.y1 + "]";
    }

    public double getDistanceFrom(Ray ray) {
        double d = (this.x - ray.getX()) / ray.getDeltaX();
        if (d < 0.0) {
            return Double.POSITIVE_INFINITY;
        }
        double d2 = ray.getY() + d * ray.getDeltaY();
        if (d2 < this.y0 || d2 > this.y1) {
            return Double.POSITIVE_INFINITY;
        }
        return d;
    }

    public Ray getNormal(double d, double d2) {
        return Ray.create(d, d2, 1.0, 0.0);
    }

    public TextureColumn getTextureColumn(double d, double d2) {
        double d3 = d2 - this.y0;
        d3 -= (double)((int)d3);
        int n = Math.min(this.texture.getWidth() - 1, (int)Math.round((double)this.texture.getWidth() * d3));
        return this.texture.getColumn(n);
    }

    public Bounds getBounds() {
        return Bounds.create(this.x, this.y0, 0.0, this.y1 - this.y0);
    }

    public void draw(Graphics graphics, double d, double d2, double d3, double d4) {
        int n = (int)(d + d3 * this.x);
        int n2 = (int)(d2 + d4 * this.y0);
        int n3 = (int)(d2 + d4 * this.y1);
        graphics.setColor(this.texture.getMeanColor());
        graphics.drawLine(n, n2, n, n3);
    }
}

