/*
 * Decompiled with CFR 0.152.
 */
public class Bounds {
    public static final Bounds EMPTY_BOUNDS = new Bounds(0.0, 0.0, 0.0, 0.0);
    private double x0;
    private double y0;
    private double x1;
    private double y1;

    private Bounds(double d, double d2, double d3, double d4) {
        this.x0 = d;
        this.y0 = d2;
        this.x1 = d3;
        this.y1 = d4;
    }

    public boolean contains(Bounds bounds) {
        if (bounds == EMPTY_BOUNDS) {
            return true;
        }
        if (this == EMPTY_BOUNDS) {
            return false;
        }
        return bounds.x0 >= this.x0 && bounds.y0 >= this.y0 && bounds.x1 <= this.x1 && bounds.y1 <= this.y1;
    }

    public Bounds add(Bounds bounds) {
        if (this == EMPTY_BOUNDS) {
            return bounds;
        }
        if (bounds == EMPTY_BOUNDS) {
            return this;
        }
        if (bounds.contains(this)) {
            return bounds;
        }
        if (this.contains(bounds)) {
            return this;
        }
        return new Bounds(Math.min(this.x0, bounds.x0), Math.min(this.y0, bounds.y0), Math.max(this.x1, bounds.x1), Math.max(this.y1, bounds.y1));
    }

    public double getX() {
        return this.x0;
    }

    public double getY() {
        return this.y0;
    }

    public double getWidth() {
        return this.x1 - this.x0;
    }

    public double getHeight() {
        return this.y1 - this.y0;
    }

    public String toString() {
        return "Bounds[" + this.x0 + "," + this.y1 + ":" + (this.x1 - this.x0) + "/" + (this.y1 - this.y0) + "]";
    }

    public static Bounds create(double d, double d2, double d3, double d4) {
        return new Bounds(d, d2, d + d3, d2 + d4);
    }
}

