/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Dimension;
import java.awt.Image;
import java.awt.image.ImageObserver;

public class ImageUtil {
    private ImageUtil() {
    }

    public static Dimension getDimension(Image image) {
        ImgDims imgDims = new ImgDims();
        imgDims.setWidth(image.getWidth(imgDims));
        imgDims.setHeight(image.getHeight(imgDims));
        return new Dimension(imgDims.getWidth(), imgDims.getHeight());
    }

    private static class ImgDims
    implements ImageObserver {
        private int width = -1;
        private int height = -1;

        private ImgDims() {
        }

        public synchronized void setWidth(int n) {
            if (n >= 0) {
                this.width = n;
                this.notifyAll();
            }
        }

        public synchronized void setHeight(int n) {
            if (n >= 0) {
                this.height = n;
                this.notifyAll();
            }
        }

        public synchronized int getWidth() {
            try {
                while (this.width < 0) {
                    this.wait();
                }
                return this.width;
            }
            catch (InterruptedException interruptedException) {
                return -1;
            }
        }

        public synchronized int getHeight() {
            try {
                while (this.height < 0) {
                    this.wait();
                }
                return this.height;
            }
            catch (InterruptedException interruptedException) {
                return -1;
            }
        }

        public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
            if ((n & 1) != 0) {
                this.setWidth(n4);
            }
            if ((n & 2) != 0) {
                this.setHeight(n5);
            }
            return this.width < 0 || this.height < 0;
        }
    }
}

