/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics;

public class LatWall
implements Surface {
    private double y;
    private double x0;
    private double x1;
    private Texture texture;

    public LatWall(double d, double d2, double d3, Texture texture) {
        this.y = d;
        this.x0 = Math.min(d2, d3);
        this.x1 = Math.max(d2, d3);
        this.texture = texture;
    }

    public String toString() {
        return "LatWall[" + this.x0 + ".." + this.x1 + "," + this.y + "]";
    }

    public double getDistanceFrom(Ray ray) {
        double d = (this.y - ray.getY()) / ray.getDeltaY();
        if (d < 0.0) {
            return Double.POSITIVE_INFINITY;
        }
        double d2 = ray.getX() + d * ray.getDeltaX();
        if (d2 < this.x0 || d2 > this.x1) {
            return Double.POSITIVE_INFINITY;
        }
        return d;
    }

    public Ray getNormal(double d, double d2) {
        return Ray.create(d, d2, 0.0, 1.0);
    }

    public TextureColumn getTextureColumn(double d, double d2) {
        double d3 = d - this.x0;
        d3 -= (double)((int)d3);
        int n = Math.min(this.texture.getWidth() - 1, (int)Math.round((double)this.texture.getWidth() * d3));
        return this.texture.getColumn(n);
    }

    public Bounds getBounds() {
        return Bounds.create(this.x0, this.y, this.x1 - this.x0, 0.0);
    }

    public void draw(Graphics graphics, double d, double d2, double d3, double d4) {
        int n = (int)(d + d3 * this.x0);
        int n2 = (int)(d + d3 * this.x1);
        int n3 = (int)(d2 + d4 * this.y);
        graphics.setColor(this.texture.getMeanColor());
        graphics.drawLine(n, n3, n2, n3);
    }
}

