/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.PixelGrabber;
import java.util.HashMap;

public class Texture {
    private Dimension dim;
    private Image all;
    private Color mean;
    private TextureColumn[] columns;
    private static HashMap loaded = new HashMap();

    private Texture(Dimension dimension, Image image, int[] nArray) {
        int n;
        this.dim = dimension;
        this.all = image;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        for (n = 0; n < nArray.length; ++n) {
            int n5 = nArray[n];
            n2 += n5 >> 16 & 0xFF;
            n3 += n5 >> 8 & 0xFF;
            n4 += n5 & 0xFF;
        }
        this.mean = new Color(n2 / nArray.length, n3 / nArray.length, n4 / nArray.length);
        this.columns = new TextureColumn[dimension.width];
        for (n = 0; n < dimension.width; ++n) {
            this.columns[n] = new TextureColumn(nArray, n, dimension.width, dimension.height, this.mean);
        }
    }

    public int getHeight() {
        return this.dim.height;
    }

    public int getWidth() {
        return this.dim.width;
    }

    public Color getMeanColor() {
        return this.mean;
    }

    public TextureColumn getColumn(int n) {
        return this.columns[n];
    }

    public static Texture load(String string) {
        Texture texture = (Texture)loaded.get(string);
        if (texture != null) {
            return texture;
        }
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Image image = toolkit.createImage(string);
        if (image == null) {
            System.out.println("null image");
            return null;
        }
        Dimension dimension = ImageUtil.getDimension(image);
        if (dimension.width <= 0 || dimension.height <= 0) {
            System.out.println("empty image");
            return null;
        }
        int[] nArray = new int[dimension.width * dimension.height];
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, dimension.width, dimension.height, nArray, 0, dimension.width);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            System.out.println("not grabbed");
            return null;
        }
        if ((pixelGrabber.getStatus() & 0x80) != 0) {
            System.out.println("aborted");
            return null;
        }
        texture = new Texture(dimension, image, nArray);
        loaded.put(string, texture);
        return texture;
    }
}

