/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;

public class TextureColumn {
    private int[] src;
    private Color mean;
    private int sOffs;
    private int sScan;
    private int sHeight;
    private int sLastOffs;

    TextureColumn(int[] nArray, int n, int n2, int n3, Color color) {
        this.src = nArray;
        this.sOffs = n;
        this.sScan = n2;
        this.sHeight = n3;
        this.sLastOffs = n + n2 * n3;
        this.mean = color;
    }

    public int getHeight() {
        return this.sHeight;
    }

    public void fill(int[] nArray, int n, int n2, int n3, double d) {
        double d2 = (double)n3 / (double)this.sHeight;
        int n4 = Math.min(nArray.length, n + n2 * n3);
        if (d > 1.0) {
            d = 1.0;
        }
        int n5 = (this.mean.getRed() + this.mean.getGreen() * 5 / 4 + this.mean.getBlue()) / 3;
        if (d2 >= 1.0) {
            int n6;
            int n7;
            double d3 = 0.0;
            double d4 = 0.0;
            double d5 = 0.0;
            double d6 = 0.0;
            int n8 = n;
            int n9 = this.sOffs;
            if (n8 < 0) {
                n7 = -n / n2;
                n6 = (int)Math.round((double)n7 / d2);
                n8 += n7 * n2;
                n9 += n6 % this.sHeight * this.sScan;
            }
            while (n8 < n4) {
                n7 = this.src[n9] >> 16 & 0xFF;
                n6 = this.src[n9] >> 8 & 0xFF;
                int n10 = this.src[n9] & 0xFF;
                if ((n9 += this.sScan) == this.sLastOffs) {
                    n9 = this.sOffs;
                }
                double d7 = 1.0 - d3;
                d4 += (double)n7 * d7;
                d5 += (double)n6 * d7;
                d6 += (double)n10 * d7;
                if (n8 >= 0) {
                    nArray[n8] = TextureColumn.toRgb((int)d4, (int)d5, (int)d6, d);
                }
                n8 += n2;
                int n11 = TextureColumn.toRgb(n7, n6, n10, d);
                for (d3 = d2 - d7; d3 >= 1.0 && n8 < n4; n8 += n2, d3 -= 1.0) {
                    if (n8 < 0) continue;
                    nArray[n8] = n11;
                }
                d4 = (double)n7 * d3;
                d5 = (double)n6 * d3;
                d6 = (double)n10 * d3;
            }
        } else if (d2 > 0.0) {
            double d8;
            double d9 = d8 = 1.0 / d2;
            double d10 = d2 * d;
            int n12 = 0;
            int n13 = 0;
            int n14 = 0;
            int n15 = n;
            int n16 = this.sOffs;
            while (n15 < n4) {
                int n17 = this.src[n16] >> 16 & 0xFF;
                int n18 = this.src[n16] >> 8 & 0xFF;
                int n19 = this.src[n16] & 0xFF;
                if ((n16 += this.sScan) == this.sLastOffs) {
                    n16 = this.sOffs;
                }
                if (d9 > 1.0) {
                    n12 += n17;
                    n13 += n18;
                    n14 += n19;
                    d9 -= 1.0;
                    continue;
                }
                int n20 = (int)((double)n17 * d9);
                n12 += n20;
                int n21 = (int)((double)n18 * d9);
                n13 += n21;
                int n22 = (int)((double)n19 * d9);
                n14 += n22;
                if (n15 >= 0) {
                    nArray[n15] = TextureColumn.toRgb(n12, n13, n14, d10);
                }
                n15 += n2;
                n12 = n17 - n20;
                n13 = n18 - n21;
                n14 = n19 - n22;
                d9 = d8 - (1.0 - d9);
            }
        } else {
            throw new IllegalArgumentException("invalid scale " + d2);
        }
    }

    private static int toRgb(int n, int n2, int n3, double d) {
        int n4;
        int n5;
        int n6 = (int)((double)n * d);
        if (n6 > 255) {
            n6 = 255;
        }
        if ((n5 = (int)((double)n2 * d)) > 255) {
            n5 = 255;
        }
        if ((n4 = (int)((double)n3 * d)) > 255) {
            n4 = 255;
        }
        return 0xFF000000 | n6 << 16 | n5 << 8 | n4;
    }
}

