/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;

public class User {
    private ArrayList listeners;
    private World world;
    private double x;
    private double y;
    private double theta;
    private double viewAngle;

    public User(World world) {
        this.world = world;
        this.listeners = new ArrayList();
        this.x = 0.0;
        this.y = 0.0;
        this.theta = 0.0;
        this.viewAngle = 0.5235987755982988;
    }

    public User(User user) {
        this.listeners = new ArrayList();
        this.world = user.world;
        this.x = user.x;
        this.y = user.y;
        this.theta = user.theta;
        this.viewAngle = user.viewAngle;
    }

    public World getWorld() {
        return this.world;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getTheta() {
        return this.theta;
    }

    public double getViewAngle() {
        return this.viewAngle;
    }

    public void addUserListener(UserListener userListener) {
        this.listeners.add(userListener);
    }

    public void removeUserListener(UserListener userListener) {
        this.listeners.remove(userListener);
    }

    private void fireUserMoved() {
        UserEvent userEvent = new UserEvent(this);
        for (int i = 0; i < this.listeners.size(); ++i) {
            UserListener userListener = (UserListener)this.listeners.get(i);
            userListener.userMoved(userEvent);
        }
    }

    public Ray getViewRay(double d) {
        double d2 = this.theta - d * this.viewAngle;
        return Ray.create(this.x, this.y, Math.cos(d2), Math.sin(d2));
    }

    public void turnAndStep(double d, double d2) {
        this.theta += d;
        if (d2 != 0.0) {
            this.stepForward(d2);
        } else {
            this.fireUserMoved();
        }
    }

    private void stepForward(double d) {
        Intersection intersection;
        Ray ray = this.getViewRay(0.0);
        if (d < 0.0) {
            ray = ray.getReverse();
        }
        if ((intersection = this.world.getClosestIntersection(ray)) != null && Math.abs(d) >= intersection.getDistance() - 0.001) {
            d = d > 0.0 ? intersection.getDistance() - 0.001 : -(intersection.getDistance() - 0.001);
        }
        this.x += d * Math.cos(this.theta);
        this.y += d * Math.sin(this.theta);
        this.fireUserMoved();
    }
}

