/** Holds information about where a ray intersects with a
 * surface in the world.
 */
public class Intersection {
	private double dist;
	private Surface surf;
	private Ray normal;

	/** Constructs an Intersection object holding the given
	 * information.
	 *
	 * @param dist the distance along the viewing ray that the
	 * surface appears.
	 * @param surf the surface that it intersects.
	 * @param normal the ray normal to the surface at this
	 * point of intersection.
	 */
	public Intersection(double dist, Surface surf, Ray normal) {
		this.dist = dist;
		this.surf = surf;
		this.normal = normal;
	}

	/** Returns the ``distance'' along the viewing ray that the
	 * surface appears. The documentation for Surface's
	 * <code>getDistanceFrom</code> method defines what this
	 * distance is.
	 *
	 * @return the ``distance'' along the viewing ray to this
	 * intersection.
	 */
	public double getDistance() {
		return dist;
	}

	/** Returns the surface at this intersection point.
	 *
	 * @return the surface at this intersection point.
	 */
	public Surface getSurface() {
		return surf;
	}

	/** Returns the ray normal to the surface at this
	 * intersection point. This normal ray will start at the
	 * intersection point, and its direction will be
	 * perpendicular to the tangent to the surface at this
	 * point.
	 *
	 * @return the ray normal to the surface at this
	 * intersection point.
	 */
	public Ray getNormalRay() {
		return normal;
	}
}
