import java.awt.Color;
import java.awt.Graphics;

/** Represents a wall running north-south (following a
 * longitude on the earth's surface).
 */
public class LongWall implements Surface {
	private double x;
	private double y0;
	private double y1;
	private Texture texture;

	public LongWall(double x, double y0, double y1, Texture txt) {
		this.x = x;
		this.y0 = Math.min(y0, y1);
		this.y1 = Math.max(y0, y1);
		this.texture = txt;
	}

	public String toString() {
		return "LongWall[" + x + "," + y0 + "-" + y1 + "]";
	}

	public double getDistanceFrom(Ray ray) {
		double ret = (x - ray.getX()) / ray.getDeltaX();
		if(ret < 0.0) return Double.POSITIVE_INFINITY;
		double hity = ray.getY() + ret * ray.getDeltaY();
		if(hity < y0 || hity > y1) return Double.POSITIVE_INFINITY;
		return ret;
	}

	public Ray getNormal(double px, double py) {
		return Ray.create(px, py, 1, 0);
	}

	public TextureColumn getTextureColumn(double x, double y) {
		double offs = y - y0; offs -= (int) offs;
		int c = Math.min(texture.getWidth() - 1,
					(int) Math.round(texture.getWidth() * offs));
		return texture.getColumn(c);
	}

	public Bounds getBounds() {
		return Bounds.create(x, y0, 0, y1 - y0);
	}

	public void draw(Graphics g, double dx, double dy, double sx, double sy) {
		int wx  = (int) (dx + sx * x);
		int wy0 = (int) (dy + sy * y0);
		int wy1 = (int) (dy + sy * y1);
		g.setColor(texture.getMeanColor());
		g.drawLine(wx, wy0, wx, wy1);
	}

}
