import java.io.File;
import java.io.File;
import java.io.IOException;
import java.io.FileReader;

/** Contains the main method enabling the program to be run as
 * an application. To run the program, the user should provide
 * a filename on the command line, for a file containing a
 * description of the world. */
public class Main {
	private Main() { }

	public static void main(String[] args) {
		if(args.length != 1) {
			System.err.println("file name missing from command line");
			System.err.println("usage: java surface.Main world_file");
			return;
		}
		File f = new File(args[0]);
		if(!f.canRead()) {
			System.err.println("File is not readable");
			return;
		}
		try {
			World walls = World.read(new FileReader(f));
			new Frame(walls).setVisible(true);
		} catch(IOException e) {
			System.out.println(e.getMessage());
		}
	}
}
