import java.awt.*;
import java.awt.image.*;
import javax.swing.*;
import java.util.Arrays;

/** Holds the method for computing the user's first-person
 * view. */
public class View {
	private View() { }

	/** Computes the user's first-person view.
	 *
	 * @param user holds information about the user, including
	 * the user's position and the world where the user is
	 * located.
	 *
	 * @param pixels an array with one <tt>int</tt> for each
	 * pixel to be drawn for the user. Entry 0 is the upper
	 * left corner of the image, while entry <code>width</code> is
	 * the pixel just below that, and entry <code>height</code> *
	 * <code>width</code> - 1 is the lower right pixel. Each
	 * <code>int</code> holds four 8-bit values packed together
	 * representing that pixel's color, with the upper byte
	 * being the pixel's opaqueness, the next byte being its
	 * red value, then its green value, then its blue value.
	 *
	 * @param width the width of the user's view.
	 *
	 * @param height the height of the user's view.
	 */
	public static void fillPixels(User user, int[] pixels,
			int width, int height) {
		// Fill screen with black. (This will end up being the
		// floor and ceiling.)
		Arrays.fill(pixels, 0, width * height, 0xFF000000);

		// Paint walls
		// your code goes here
	}
}
