/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.image.MemoryImageSource;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.Iterator;
import javax.swing.JPanel;

public class Canvas
extends JPanel
implements ComponentListener,
UserListener,
Runnable {
    private User user;
    private Dimension size;
    private boolean pixels_filled;
    private int[] pixels;
    private MemoryImageSource producer;
    private Image img;
    private DecimalFormat form;

    public Canvas(User user) {
        this.user = user;
        this.size = new Dimension(600, 300);
        this.img = null;
        this.pixels_filled = false;
        this.form = new DecimalFormat("0.0");
        this.setBackground(Color.darkGray);
        this.setPreferredSize(this.size);
        this.addComponentListener(this);
        user.addUserListener(this);
        new Thread(this).start();
    }

    private synchronized void ensureImageExists() {
        if (this.img == null) {
            this.pixels = new int[this.size.height * this.size.width];
            this.producer = new MemoryImageSource(this.size.width, this.size.height, this.pixels, 0, this.size.width);
            this.producer.setAnimated(true);
            this.img = this.createImage(this.producer);
        }
    }

    public synchronized void userMoved(UserEvent userEvent) {
        this.pixels_filled = false;
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            MemoryImageSource memoryImageSource;
            int[] nArray;
            User user;
            Serializable serializable = this;
            synchronized (serializable) {
                while (this.pixels_filled) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            Canvas canvas = this;
            synchronized (canvas) {
                this.ensureImageExists();
                serializable = this.size;
                user = new User(this.user);
                nArray = this.pixels;
                memoryImageSource = this.producer;
            }
            View.fillPixels(user, nArray, ((Dimension)serializable).width, ((Dimension)serializable).height);
            memoryImageSource.newPixels();
            canvas = this;
            synchronized (canvas) {
                this.pixels_filled = true;
                this.notifyAll();
            }
        }
    }

    private synchronized void awaitPixelsFilled() {
        this.notifyAll();
        while (!this.pixels_filled) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        this.ensureImageExists();
        graphics.drawImage(this.img, 0, 0, this);
        this.paintPosition(graphics, 2, this.size.height - 2);
        this.paintMap(graphics, this.size.width - 75, 2, 73, 50);
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public synchronized void componentResized(ComponentEvent componentEvent) {
        Dimension dimension = this.getSize();
        if (!dimension.equals(this.size)) {
            this.size = dimension;
            this.img = null;
            this.pixels_filled = false;
            this.notifyAll();
        }
    }

    private void paintMap(Graphics graphics, int n, int n2, int n3, int n4) {
        graphics.setColor(Color.black);
        graphics.fillRect(n, n2, n3, n4);
        graphics.setColor(Color.darkGray);
        graphics.drawRect(n, n2, n3, n4);
        World world = this.user.getWorld();
        Bounds bounds = world.getBounds();
        double d = Math.min((double)n3 / bounds.getWidth(), (double)n4 / bounds.getHeight());
        double d2 = (double)n + ((double)n3 - d * bounds.getWidth()) / 2.0 - d * bounds.getX();
        double d3 = (double)(n2 + n4) - ((double)n4 - d * bounds.getHeight()) / 2.0 + d * bounds.getY();
        Iterator iterator = world.getSurfaces().iterator();
        while (iterator.hasNext()) {
            Surface surface = (Surface)iterator.next();
            surface.draw(graphics, d2, d3, d, -d);
        }
        graphics.setColor(Color.red);
        int n5 = (int)(d2 + d * this.user.getX());
        int n6 = (int)(d3 - d * this.user.getY());
        int n7 = (int)(7.0 * Math.cos(this.user.getTheta()));
        int n8 = (int)(7.0 * Math.sin(this.user.getTheta()));
        graphics.fillOval(n5 - 2, n6 - 2, 5, 5);
        graphics.drawLine(n5, n6, n5 + n7, n6 - n8);
    }

    private void paintPosition(Graphics graphics, int n, int n2) {
        double d = Math.toDegrees(this.user.getTheta());
        d -= 360.0 * (double)((int)(d / 360.0));
        String string = this.form.format(this.user.getX()) + "," + this.form.format(this.user.getY()) + "/" + this.form.format(d);
        graphics.setColor(Color.white);
        graphics.drawString(string, n, n2);
    }
}

