/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics;

public class Cylinder
implements Surface {
    private double x;
    private double y;
    private double r;
    private Texture texture;

    public Cylinder(double d, double d2, double d3, Texture texture) {
        this.x = d;
        this.y = d2;
        this.r = d3;
        this.texture = texture;
    }

    public String toString() {
        return "Cylinder[" + this.x + "," + this.y + "/" + this.r + "]";
    }

    public double getDistanceFrom(Ray ray) {
        double d;
        double d2;
        double d3;
        double d4 = ray.getX() - this.x;
        double d5 = ray.getY() - this.y;
        double d6 = ray.getDeltaX();
        double d7 = 2.0 * (d6 * d4 + (d3 = ray.getDeltaY()) * d5);
        double d8 = d7 * d7 - 4.0 * (d2 = d6 * d6 + d3 * d3) * (d = d4 * d4 + d5 * d5 - this.r * this.r);
        if (d8 < 0.0) {
            return Double.POSITIVE_INFINITY;
        }
        double d9 = -d7 - (d8 = Math.sqrt(d8));
        if (d9 < 0.0 != d2 < 0.0 && (d9 = -d7 + d8) < 0.0 != d2 < 0.0) {
            return Double.POSITIVE_INFINITY;
        }
        return d9 / (2.0 * d2);
    }

    public Ray getNormal(double d, double d2) {
        double d3 = d - this.x;
        double d4 = d2 - this.y;
        double d5 = 1.0 / Math.sqrt(d3 * d3 + d4 * d4);
        return Ray.create(d, d2, d3 * d5, d4 * d5);
    }

    public TextureColumn getTextureColumn(double d, double d2) {
        double d3 = Math.atan2(d2 - this.y, d - this.x);
        if (d3 < 0.0) {
            d3 += Math.PI * 2;
        }
        int n = (int)((double)this.texture.getWidth() * d3 / (Math.PI * 2));
        return this.texture.getColumn(n);
    }

    public Bounds getBounds() {
        return Bounds.create(this.x - this.r, this.y - this.r, 2.0 * this.r, 2.0 * this.r);
    }

    public void draw(Graphics graphics, double d, double d2, double d3, double d4) {
        int n = (int)(d + d3 * (this.x - this.r));
        int n2 = (int)(d2 + d4 * (this.y - this.r));
        int n3 = Math.max(1, (int)(d3 * (2.0 * this.r)));
        int n4 = Math.max(1, (int)(d4 * (2.0 * this.r)));
        graphics.setColor(this.texture.getMeanColor());
        graphics.drawOval(n, n2, n3, n4);
    }
}

