/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.StringTokenizer;

public class World {
    private Collection surfs;
    private Bounds bounds;

    public World(Collection collection) {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(collection);
        this.surfs = Collections.unmodifiableCollection(arrayList);
        this.bounds = Bounds.EMPTY_BOUNDS;
        Iterator iterator = this.surfs.iterator();
        while (iterator.hasNext()) {
            Surface surface = (Surface)iterator.next();
            this.bounds = this.bounds.add(surface.getBounds());
        }
    }

    public Intersection getClosestIntersection(Ray ray) {
        double d;
        double d2 = Double.POSITIVE_INFINITY;
        Surface surface = null;
        Iterator iterator = this.surfs.iterator();
        while (iterator.hasNext()) {
            Surface surface2 = (Surface)iterator.next();
            d = surface2.getDistanceFrom(ray);
            if (!(d < d2)) continue;
            d2 = d;
            surface = surface2;
        }
        if (d2 == Double.POSITIVE_INFINITY) {
            return null;
        }
        double d3 = ray.getX() + d2 * ray.getDeltaX();
        d = ray.getY() + d2 * ray.getDeltaY();
        return new Intersection(d2, surface, surface.getNormal(d3, d));
    }

    public Collection getSurfaces() {
        return this.surfs;
    }

    public Bounds getBounds() {
        return this.bounds;
    }

    public static World read(InputStream inputStream) throws IOException {
        return World.read(new InputStreamReader(inputStream));
    }

    public static World read(Reader reader) throws IOException {
        ArrayList<Surface> arrayList = new ArrayList<Surface>();
        BufferedReader bufferedReader = new BufferedReader(reader);
        int n = 0;
        while (true) {
            double d;
            double d2;
            double d3;
            int n2;
            ++n;
            String string = bufferedReader.readLine();
            if (string == null) break;
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\t");
            if (!stringTokenizer.hasMoreTokens()) continue;
            String string2 = stringTokenizer.nextToken();
            if (string2.equals("v")) {
                n2 = 0;
            } else if (string2.equals("h")) {
                n2 = 1;
            } else if (string2.equals("c")) {
                n2 = 2;
            } else {
                throw new IOException(n + ": bad type");
            }
            if (stringTokenizer.countTokens() < 4) {
                throw new IOException(n + ": missing tokens");
            }
            if (stringTokenizer.countTokens() > 4) {
                throw new IOException(n + ": extra tokens");
            }
            try {
                d3 = Double.parseDouble(stringTokenizer.nextToken());
                d2 = Double.parseDouble(stringTokenizer.nextToken());
                d = Double.parseDouble(stringTokenizer.nextToken());
            }
            catch (NumberFormatException numberFormatException) {
                throw new IOException(n + ": bad number");
            }
            Texture texture = Texture.load(stringTokenizer.nextToken());
            switch (n2) {
                case 0: {
                    arrayList.add(new LongWall(d3, d2, d, texture));
                    break;
                }
                case 1: {
                    arrayList.add(new LatWall(d3, d2, d, texture));
                    break;
                }
                case 2: {
                    arrayList.add(new Cylinder(d3, d2, d, texture));
                }
            }
        }
        return new World(arrayList);
    }
}

