import java.awt.Color;
import java.awt.Graphics;

/** Represents a vertical cylinder. */
public class Cylinder implements Surface {
	private double x;
	private double y;
	private double r;
	private Texture texture;

	public Cylinder(double x, double y, double r, Texture txt) {
		this.x = x;
		this.y = y;
		this.r = r;
		this.texture = txt;
	}

	public String toString() {
		return "Cylinder[" + x + "," + y + "/" + r + "]";
	}

	public double getDistanceFrom(Ray ray) {
		// your code goes here
		return Double.POSITIVE_INFINITY;
	}

	public Ray getNormal(double px, double py) {
		// your code goes here
		return Ray.create(px, py, 0, 1);
	}

	public TextureColumn getTextureColumn(double x, double y) {
		double th = Math.atan2(y - this.y, x - this.x);
		if(th < 0.0) th += 2 * Math.PI;
		int c = (int) (texture.getWidth() * th / (2.0 * Math.PI));
		return texture.getColumn(c);
	}

	public Bounds getBounds() {
		return Bounds.create(x - r, y - r, 2 * r, 2 * r);
	}

	public void draw(Graphics g, double dx, double dy, double sx, double sy) {
		int x0 = (int) (dx + sx * (x - r));
		int y0 = (int) (dy + sy * (y - r));
		int wd = Math.max(1, (int) (sx * (2 * r)));
		int ht = Math.max(1, (int) (sy * (2 * r)));
		g.setColor(texture.getMeanColor());
		g.drawOval(x0, y0, wd, ht);
	}
}
