import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

/** The window containing the user's view as managed by the
 * Canvas class. */
public class Frame extends JFrame
		implements WindowListener {
	private User user;
	private UserController controller;

	public Frame(World walls) {
		super.setTitle("Dungeon");
		this.user = new User(walls);
		Canvas canvas = new Canvas(user);
		controller = new UserController(user);
		this.addWindowListener(this);
		getContentPane().add(canvas);
		pack();
		canvas.addKeyListener(controller);
		canvas.grabFocus();
	}

	public void setVisible(boolean value) {
		super.setVisible(value);
		controller.start();
	}

	// WindowListener methods
	public void windowActivated(WindowEvent e) { }
	public void windowClosed(WindowEvent e) { }
	public void windowClosing(WindowEvent e) { System.exit(0); }
	public void windowDeactivated(WindowEvent e) { }
	public void windowDeiconified(WindowEvent e) { }
	public void windowIconified(WindowEvent e) { }
	public void windowOpened(WindowEvent e) { }
}
