import java.awt.Color;
import java.awt.Graphics;

/** Represents an wall running east-west (following a latitude on the
 * earth's surface).
 */
public class LatWall implements Surface {
	private double y;
	private double x0;
	private double x1;
	private Texture texture;

	public LatWall(double y, double x0, double x1, Texture txt) {
		this.y = y;
		this.x0 = Math.min(x0, x1);
		this.x1 = Math.max(x0, x1);
		this.texture = txt;
	}

	public String toString() {
		return "LatWall[" + x0 + ".." + x1 + "," + y + "]";
	}

	public double getDistanceFrom(Ray ray) {
		double ret = (y - ray.getY()) / ray.getDeltaY();
		if(ret < 0.0) return Double.POSITIVE_INFINITY;
		double hitx = ray.getX() + ret * ray.getDeltaX();
		if(hitx < x0 || hitx > x1) return Double.POSITIVE_INFINITY;
		return ret;
	}

	public Ray getNormal(double px, double py) {
		return Ray.create(px, py, 0, 1);
	}

	public TextureColumn getTextureColumn(double x, double y) {
		double offs = x - x0; offs -= (int) offs;
		int c = Math.min(texture.getWidth() - 1,
					(int) Math.round(texture.getWidth() * offs));
		return texture.getColumn(c);
	}

	public Bounds getBounds() {
		return Bounds.create(x0, y, x1 - x0, 0);
	}

	public void draw(Graphics g, double dx, double dy, double sx, double sy) {
		int wx0 = (int) (dx + sx * x0);
		int wx1 = (int) (dx + sx * x1);
		int wy  = (int) (dy + sy * y);
		g.setColor(texture.getMeanColor());
		g.drawLine(wx0, wy, wx1, wy);
	}

}
