import java.text.DecimalFormat;

/** Represents an immutable ray with a starting point and a direction. The
 * direction would normally, but not necessarily, have a length
 * of one. */
public class Ray {
	private double x;
	private double y;
	private double dx;
	private double dy;

	private Ray(double x, double y, double dx, double dy) {
		this.x = x;
		this.y = y;
		this.dx = dx;
		this.dy = dy;
	}

	/** Returns the x-coordinate of this ray's starting point. */
	public double getX() { return x; } 

	/** Returns the y-coordinate of this ray's starting point. */
	public double getY() { return y; }

	/** Returns the change in x for one unit along this ray's direction. */
	public double getDeltaX() { return dx; }

	/** Returns the change in y for one unit along this ray's direction. */
	public double getDeltaY() { return dy; }

	/** Returns the result of the dot product of this ray's
	 * direction with the parameter ray's direction. */
	public double dot(Ray o) { return dx * o.dx + dy * o.dy; }

	/** Returns a ray in the reverse direction of this one. */
	public Ray getReverse() {
		return new Ray(x, y, -dx, -dy);
	}

	public String toString() {
		DecimalFormat form = new DecimalFormat("0.00");
		return form.format(x) + "," + form.format(y) + ">"
			+ form.format(dx) + "," + form.format(dy);
	}

	/** Returns a ray with the given starting point and
	 * direction. */
	public static Ray create(double x, double y,
			double dx, double dy) {
		return new Ray(x, y, dx, dy);
	}
}
