/*
 * Decompiled with CFR 0.152.
 */
public class TransformUtility {
    private TransformUtility() {
    }

    public static Transform viewTransform(Point point, Point point2, Vector vector) {
        Vector vector2 = point.subtract(point2);
        Vector vector3 = vector.cross(vector2);
        Vector vector4 = vector2.cross(vector3);
        Vector vector5 = point.subtract(Point.ORIGIN);
        vector2 = vector2.normalize();
        vector3 = vector3.normalize();
        vector4 = vector4.normalize();
        return Transform.create(new double[]{vector3.getX(), vector3.getY(), vector3.getZ(), -vector5.dot(vector3), vector4.getX(), vector4.getY(), vector4.getZ(), -vector5.dot(vector4), vector2.getX(), vector2.getY(), vector2.getZ(), -vector5.dot(vector2), 0.0, 0.0, 0.0, 1.0});
    }

    public static Transform orthographicProjection(double d, double d2, double d3, double d4, double d5, double d6) {
        return Transform.scale(2.0 / (d2 - d), 2.0 / (d4 - d3), 2.0 / (d6 - d5)).append(Transform.translate(-(d + d2) / 2.0, -(d3 + d4) / 2.0, -(d5 + d6) / 2.0));
    }

    public static Transform perspectiveProjection(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7 = -(d6 + d5) / (d6 - d5);
        double d8 = -2.0 * d6 * d5 / (d6 - d5);
        return Transform.create(new double[]{2.0 * d5 / (d2 - d), 0.0, (d2 + d) / (d2 - d), 0.0, 0.0, 2.0 * d5 / (d4 - d3), (d4 + d3) / (d4 - d3), 0.0, 0.0, 0.0, d7, d8, 0.0, 0.0, -1.0, 0.0});
    }
}

