/*
 * Decompiled with CFR 0.152.
 */
public class Vector {
    private double x;
    private double y;
    private double z;

    private Vector(double d, double d2, double d3) {
        this.x = d;
        this.y = d2;
        this.z = d3;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public double getLength() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public Vector normalize() {
        double d = this.getLength();
        if (d == 0.0) {
            return this;
        }
        return this.scale(1.0 / d);
    }

    public double dot(Vector vector) {
        return this.x * vector.x + this.y * vector.y + this.z * vector.z;
    }

    public Vector cross(Vector vector) {
        return Vector.create(this.y * vector.z - this.z * vector.y, this.z * vector.x - this.x * vector.z, this.x * vector.y - this.y * vector.x);
    }

    public Vector add(Vector vector) {
        return Vector.create(this.x + vector.x, this.y + vector.y, this.z + vector.z);
    }

    public Vector subtract(Vector vector) {
        return Vector.create(this.x - vector.x, this.y - vector.y, this.z - vector.z);
    }

    public Vector projectOnto(Vector vector) {
        double d = this.dot(vector);
        return vector.scale(d);
    }

    public Vector scale(double d) {
        if (d == 1.0) {
            return this;
        }
        return Vector.create(d * this.x, d * this.y, d * this.z);
    }

    public String toString() {
        return "(" + this.x + "," + this.y + "," + this.z + ")";
    }

    public static Vector create(double d, double d2, double d3) {
        return new Vector(d, d2, d3);
    }
}

