/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;

public abstract class Model {
    public static final Model EMPTY = new Empty();

    public abstract void draw(Graphics3D var1);

    public Model color(Color color) {
        return new ColoredModel(this, color);
    }

    public Model transform(Transform transform) {
        return new TransformedModel(this, transform);
    }

    public Model scale(double d, double d2, double d3) {
        return this.transform(Transform.scale(d, d2, d3));
    }

    public Model translate(double d, double d2, double d3) {
        return this.transform(Transform.translate(d, d2, d3));
    }

    public Model rotateX(double d) {
        return this.transform(Transform.rotateX(d));
    }

    public Model rotateY(double d) {
        return this.transform(Transform.rotateY(d));
    }

    public Model rotateZ(double d) {
        return this.transform(Transform.rotateZ(d));
    }

    private static class ColoredModel
    extends Model {
        private Model model;
        private Color color;

        public ColoredModel(Model model, Color color) {
            this.model = model;
            this.color = color;
        }

        public void draw(Graphics3D graphics3D) {
            Color color = graphics3D.getColor();
            graphics3D.setColor(this.color);
            this.model.draw(graphics3D);
            graphics3D.setColor(color);
        }
    }

    private static class TransformedModel
    extends Model {
        private Model model;
        private Transform x;

        public TransformedModel(Model model, Transform transform) {
            this.model = model;
            this.x = transform;
        }

        public void draw(Graphics3D graphics3D) {
            Transform transform = graphics3D.getModelTransform();
            graphics3D.setModelTransform(transform.append(this.x));
            this.model.draw(graphics3D);
            graphics3D.setModelTransform(transform);
        }

        public Model transform(Transform transform) {
            return new TransformedModel(this.model, transform.append(this.x));
        }
    }

    private static class Empty
    extends Model {
        private Empty() {
        }

        public void draw(Graphics3D graphics3D) {
        }

        public Model transform(Transform transform) {
            return this;
        }
    }
}

