/*
 * Decompiled with CFR 0.152.
 */
public class Point {
    public static Point ORIGIN = new Point(0.0, 0.0, 0.0, 1.0);
    private double x;
    private double y;
    private double z;
    private double h;

    private Point(double d, double d2, double d3, double d4) {
        this.x = d;
        this.y = d2;
        this.z = d3;
        this.h = d4;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public double getHomogeneous() {
        return this.h;
    }

    public String toString() {
        return "(" + this.x + "," + this.y + "," + this.z + "," + this.h + ")";
    }

    public double getDistanceTo(Point point) {
        double d = point.h;
        double d2 = this.x / this.h - point.x / d;
        double d3 = this.y / this.h - point.y / d;
        double d4 = this.z / this.h - point.z / d;
        return Math.sqrt(d2 * d2 + d3 * d3 + d4 * d4);
    }

    public Vector subtract(Point point) {
        double d = point.h;
        double d2 = this.x / this.h - point.x / d;
        double d3 = this.y / this.h - point.y / d;
        double d4 = this.z / this.h - point.z / d;
        return Vector.create(d2, d3, d4);
    }

    public Point addScaled(double d, Vector vector) {
        return Point.create(this.x + (d *= this.h) * vector.getX(), this.y + d * vector.getY(), this.z + d * vector.getZ(), this.h);
    }

    public Point add(Vector vector) {
        return this.addScaled(1.0, vector);
    }

    public static Point create(double d, double d2, double d3) {
        return new Point(d, d2, d3, 1.0);
    }

    public static Point create(double d, double d2, double d3, double d4) {
        return new Point(d, d2, d3, d4);
    }
}

