/*
 * Decompiled with CFR 0.152.
 */
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;

public class TestWindow
extends ModelViewer {
    private static double RADIUS = 3.0;
    private Controller controller = new Controller();

    public TestWindow(Model model) {
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.add(new FileMenu());
        jMenuBar.add(new ProjectionMenu());
        this.setJMenuBar(jMenuBar);
        this.setModel(model);
        this.addKeyListener(this.controller);
        this.addFocusListener(this.controller);
        this.grabFocus();
        this.controller.start();
    }

    private class ProjectionMenu
    extends JMenu
    implements ActionListener {
        private JRadioButtonMenuItem ortho;
        private JRadioButtonMenuItem persp;

        public ProjectionMenu() {
            super("Projection");
            ButtonGroup buttonGroup = new ButtonGroup();
            this.ortho = new JRadioButtonMenuItem("Orthographic");
            this.ortho.addActionListener(this);
            this.add(this.ortho);
            buttonGroup.add(this.ortho);
            this.persp = new JRadioButtonMenuItem("Perspective");
            this.persp.addActionListener(this);
            this.add(this.persp);
            buttonGroup.add(this.persp);
            this.setToPerspective();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.ortho.isSelected()) {
                this.setToOrthographic();
            }
            if (this.persp.isSelected()) {
                this.setToPerspective();
            }
        }

        public void setToOrthographic() {
            this.ortho.setSelected(true);
            TestWindow.this.setProjectionTransform(TransformUtility.orthographicProjection(-1.0, 1.0, -1.0, 1.0, RADIUS - 1.0, RADIUS + 1.0));
        }

        public void setToPerspective() {
            this.persp.setSelected(true);
            TestWindow.this.setProjectionTransform(TransformUtility.perspectiveProjection(-1.0, 1.0, -1.0, 1.0, RADIUS - 1.0, RADIUS + 1.0));
        }
    }

    private class FileMenu
    extends JMenu
    implements ActionListener {
        private JMenuItem reset = new JMenuItem("Reset");
        private JMenuItem quit;

        public FileMenu() {
            super("File");
            this.reset.addActionListener(this);
            this.add(this.reset);
            this.quit = new JMenuItem("Quit");
            this.quit.addActionListener(this);
            this.add(this.quit);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == this.quit) {
                System.exit(0);
            } else if (object == this.reset) {
                TestWindow.this.controller.resetPosition();
            }
        }
    }

    private class Controller
    extends Thread
    implements KeyListener,
    FocusListener {
        int dx = 0;
        int dy = 0;
        Vector u;
        Vector v;
        Vector n;
        boolean view_dirty;

        Controller() {
            this.resetPosition();
        }

        public void resetPosition() {
            this.u = Vector.create(0.0, 1.0, 0.0);
            this.v = Vector.create(1.0, 0.0, 0.0);
            this.n = Vector.create(0.0, 0.0, 1.0);
            this.view_dirty = true;
            this.computeView();
        }

        public void run() {
            while (true) {
                try {
                    Thread.sleep(40L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.step();
                this.computeView();
            }
        }

        private void step() {
            Vector vector = this.n;
            if (this.dy != 0) {
                vector = vector.add(this.u.scale(0.1 * (double)this.dy));
            }
            if (this.dx != 0) {
                vector = vector.add(this.v.scale(0.1 * (double)this.dx));
            }
            if (vector == this.n) {
                return;
            }
            vector = vector.scale(1.0 / vector.getLength());
            this.n = vector.scale(1.0 / vector.getLength());
            this.u = this.u.subtract(this.u.projectOnto(this.n));
            this.v = this.v.subtract(this.v.projectOnto(this.n));
            this.view_dirty = true;
        }

        private void computeView() {
            if (!this.view_dirty) {
                return;
            }
            this.view_dirty = false;
            TestWindow.this.setViewTransform(TransformUtility.viewTransform(Point.ORIGIN.addScaled(RADIUS, this.n), Point.ORIGIN, this.u));
        }

        public void keyPressed(KeyEvent keyEvent) {
            switch (keyEvent.getKeyCode()) {
                case 38: 
                case 224: {
                    ++this.dy;
                    break;
                }
                case 40: 
                case 225: {
                    --this.dy;
                    break;
                }
                case 37: 
                case 226: {
                    --this.dx;
                    break;
                }
                case 39: 
                case 227: {
                    ++this.dx;
                }
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
            switch (keyEvent.getKeyCode()) {
                case 38: 
                case 224: {
                    --this.dy;
                    break;
                }
                case 40: 
                case 225: {
                    ++this.dy;
                    break;
                }
                case 37: 
                case 226: {
                    ++this.dx;
                    break;
                }
                case 39: 
                case 227: {
                    --this.dx;
                }
            }
        }

        public void keyTyped(KeyEvent keyEvent) {
        }

        public void focusGained(FocusEvent focusEvent) {
        }

        public void focusLost(FocusEvent focusEvent) {
            this.dx = 0;
            this.dy = 0;
        }
    }
}

