/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.FocusListener;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class ModelViewer
extends JFrame {
    private Canvas canvas = new Canvas();
    private Model model = Model.EMPTY;
    private Transform V = Transform.IDENTITY;
    private Transform P = Transform.IDENTITY;

    public ModelViewer() {
        this.setTitle("Model Viewer");
        this.addWindowListener(new WindowCloser());
        this.getContentPane().add(this.canvas);
        this.pack();
    }

    public void addKeyListener(KeyListener keyListener) {
        this.canvas.addKeyListener(keyListener);
    }

    public void removeKeyListener(KeyListener keyListener) {
        this.canvas.removeKeyListener(keyListener);
    }

    public void addFocusListener(FocusListener focusListener) {
        this.canvas.addFocusListener(focusListener);
    }

    public void removeFocusListener(FocusListener focusListener) {
        this.canvas.removeFocusListener(focusListener);
    }

    public void grabFocus() {
        this.canvas.grabFocus();
    }

    public void setModel(Model model) {
        this.model = model;
        this.canvas.repaint();
    }

    public void setViewTransform(Transform transform) {
        this.V = transform;
        this.canvas.repaint();
    }

    public void setProjectionTransform(Transform transform) {
        this.P = transform;
        this.canvas.repaint();
    }

    private class WindowCloser
    extends WindowAdapter {
        private WindowCloser() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            System.exit(0);
        }
    }

    private class Canvas
    extends JPanel {
        public Canvas() {
            this.setBackground(Color.white);
            this.setPreferredSize(new Dimension(300, 300));
        }

        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            Dimension dimension = this.getSize();
            double d = dimension.getWidth();
            double d2 = dimension.getHeight();
            Graphics3D graphics3D = new Graphics3D(graphics);
            graphics3D.setViewTransform(ModelViewer.this.V);
            graphics3D.setProjectionTransform(ModelViewer.this.P);
            graphics3D.setViewFrameTransform(Transform.translate(1.0, 1.0, 1.0).prepend(Transform.scale(d / 2.0, -d2 / 2.0, 1.0)).prepend(Transform.translate(0.0, d2, 0.0)));
            ModelViewer.this.model.draw(graphics3D);
        }
    }
}

