/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;

public class Graphics3D {
    private Graphics g;
    private Transform M;
    private Transform V;
    private Transform P;
    private Transform Vf;

    public Graphics3D(Graphics graphics) {
        this.g = graphics;
        this.V = Transform.IDENTITY;
        this.M = Transform.IDENTITY;
        this.P = Transform.IDENTITY;
        this.Vf = Transform.IDENTITY;
    }

    public Color getColor() {
        return this.g.getColor();
    }

    public Transform getModelTransform() {
        return this.M;
    }

    public Transform getViewTransform() {
        return this.V;
    }

    public Transform getProjectionTransform() {
        return this.P;
    }

    public Transform getViewFrameTransform() {
        return this.Vf;
    }

    public void setColor(Color color) {
        this.g.setColor(color);
    }

    public void setModelTransform(Transform transform) {
        this.M = transform;
    }

    public void setViewTransform(Transform transform) {
        this.V = transform;
    }

    public void setProjectionTransform(Transform transform) {
        this.P = transform;
    }

    public void setViewFrameTransform(Transform transform) {
        this.Vf = transform;
    }

    public void drawPolygon(Point[] pointArray) {
        for (int i = 1; i < pointArray.length; ++i) {
            this.drawLine(pointArray[i - 1], pointArray[i]);
        }
        this.drawLine(pointArray[pointArray.length - 1], pointArray[0]);
    }

    public void drawLine(Point point, Point point2) {
        point = this.sendThroughPipeline(point);
        point2 = this.sendThroughPipeline(point2);
        this.g.drawLine((int)point.getX(), (int)point.getY(), (int)point2.getX(), (int)point2.getY());
    }

    private Point sendThroughPipeline(Point point) {
        point = this.M.transform(point);
        point = this.V.transform(point);
        point = this.P.transform(point);
        double d = point.getHomogeneous();
        point = Point.create(point.getX() / d, point.getY() / d, point.getZ() / d);
        point = this.Vf.transform(point);
        return point;
    }
}

