#include <stdlib.h>
#include <math.h>
#include <GL/glut.h>

/* Returns a random number selected from a uniform distribution
 * ranging from 0.0 to 1.0. */
double randomUniform() {
    return (double) random() / RAND_MAX;
}

/* Returns a random number selected from a Gaussian distribution
 * (also known as a normal distribution or a bell curve) whose
 * mean is 0.0 and whose variance is 1.0. Roughly, there is a
 * 68% chance that the returned value is between -1.0 and 1.0;
 * and a 95% chance that it is between -2.0 * and 2.0. */
double randomGaussian() {
    float x1, x2, w;

    do {
        x1 = 2.0 * randomUniform() - 1.0;
        x2 = 2.0 * randomUniform() - 1.0;
        w = x1 * x1 + x2 * x2;
    } while ( w >= 1.0 );

    w = sqrt( (-2.0 * log( w ) ) / w );
    return x1 * w; // x2 * w is independent, random
}
