#ifndef _RANDOM_H_
#define _RANDOM_H_

/* Returns a random number selected from a uniform distribution
 * ranging from 0.0 to 1.0. */
double randomUniform();

/* Returns a random number selected from a Gaussian distribution
 * (also known as a normal distribution or a bell curve) whose
 * mean is 0.0 and whose variance is 1.0. Roughly, there is a
 * 68% chance that the returned value is between -1.0 and 1.0;
 * and a 95% chance that it is between -2.0 * and 2.0. */
double randomGaussian();

#endif /* _RANDOM_H_ */
