#ifndef _TERRAIN_H_
#define _TERRAIN_H_

/* Controls the number of grid squares along each dimension of the
 * terrain. That is, the grid will contain TERRAIN_WIDTH + 1 by
 * TERRAIN_WIDTH + 1 height values. This constant should always
 * be set to a power of 2.
 *
 * Bigger values result in more impressive terrains, but
 * the larger number of polygons can stretch a computer's
 * computational capacity. I found that, for the laboratory
 * computers without graphics accelerators, a value of 32 or
 * less allows for smooth navigation around the island.
 * With graphics acceleration, 256 was relatively smooth. */
#define TERRAIN_WIDTH 16

/* Controls the terrain's "roughness": A larger value results
 * in a terrain with more varied slopes. */
#define ROUGHNESS 0.25

/* Pre-computes the heights for this terrain, where the edges
 * of the terrain are fixed at 0.0, and the center of the
 * terrain is fixed at 1.0. */
void terrainInit();

/* Draws this terrain in the square bounded by the x-values
 * from 0 to 1 and by the y-values from 0 to 1. The z-values
 * correspond to the different points' heights. */
void terrainDraw();

#endif /* _TERRAIN_H_ */
