/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.image.MemoryImageSource;
import javax.swing.JPanel;

public class Canvas
extends JPanel {
    private Dimension size = null;
    private boolean pixels_filled = false;
    private int[] pixels;
    private MemoryImageSource producer;
    private Image img = null;

    public Canvas() {
        Helper helper = new Helper();
        this.addComponentListener(helper);
    }

    public int[] getPixels() {
        this.ensureImageExists();
        return this.pixels;
    }

    public void newPixels(int[] nArray) {
        if (nArray == this.pixels) {
            this.producer.newPixels();
        }
    }

    private synchronized void ensureImageExists() {
        if (this.img == null) {
            if (this.size == null) {
                this.size = this.getSize();
            }
            this.pixels = new int[this.size.height * this.size.width];
            this.producer = new MemoryImageSource(this.size.width, this.size.height, this.pixels, 0, this.size.width);
            this.producer.setAnimated(true);
            this.img = this.createImage(this.producer);
        }
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        this.ensureImageExists();
        graphics.drawImage(this.img, 0, 0, this);
    }

    private class Helper
    implements ComponentListener {
        private Helper() {
        }

        public void componentHidden(ComponentEvent componentEvent) {
        }

        public void componentMoved(ComponentEvent componentEvent) {
        }

        public void componentShown(ComponentEvent componentEvent) {
        }

        public synchronized void componentResized(ComponentEvent componentEvent) {
            Dimension dimension = Canvas.this.getSize();
            if (!dimension.equals(Canvas.this.size)) {
                Canvas.this.size = dimension;
                Canvas.this.img = null;
                Canvas.this.pixels_filled = false;
                this.notifyAll();
            }
        }
    }
}

