/*
 * Decompiled with CFR 0.152.
 */
public class Interpolation {
    public static final int MIDPOINT = 0;
    public static final int MINIMUM = 1;
    public static final int MAXIMUM = 2;
    private int cur;
    private int dcur;
    private int correct_cur;
    private int err;
    private int derr;
    private int correct_err;

    public Interpolation(int n, int n2, int n3) {
        this(n, n2, n3, 0);
    }

    public Interpolation(int n, int n2, int n3, int n4) {
        if (n3 < 0) {
            throw new IllegalArgumentException("Interpolation possible only across a non-negative steps.");
        }
        if (n3 == 0) {
            this.dcur = 0;
            this.err = -1;
            this.derr = 0;
            this.cur = (n + n2) / 2;
        } else if (n < n2) {
            int n5 = n2 - n;
            this.cur = n;
            this.dcur = n5 / n3;
            this.correct_cur = 1;
            this.err = -n3;
            this.derr = 2 * n5 - 2 * n3 * this.dcur;
            this.correct_err = -2 * n3;
        } else {
            int n6 = n - n2;
            this.cur = n;
            this.dcur = -(n6 / n3);
            this.correct_cur = -1;
            this.err = -n3;
            this.derr = 2 * n6 + 2 * n3 * this.dcur;
            this.correct_err = -2 * n3;
        }
    }

    public int next() {
        int n = this.cur;
        this.cur += this.dcur;
        this.err += this.derr;
        if (this.err > 0) {
            this.cur += this.correct_cur;
            this.err += this.correct_err;
        }
        return n;
    }

    public static void main(String[] stringArray) {
        int n = Integer.parseInt(stringArray[0]);
        int n2 = Integer.parseInt(stringArray[1]);
        int n3 = Integer.parseInt(stringArray[2]);
        int n4 = Integer.parseInt(stringArray[3]);
        Interpolation interpolation = new Interpolation(n, n2, n3, n4);
        for (int i = 0; i <= n3; ++i) {
            System.out.printf("%3d  %3d\n", i, interpolation.next());
        }
    }
}

