/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.util.Arrays;

public class Graphics3D {
    private int[] pixels;
    private double[] depth;
    private int width;
    private int height;
    private int color;
    private LightModel lighting;
    private Transform M;
    private Transform V;
    private Transform P;
    private Transform Vf;

    public Graphics3D(int[] nArray, int n, int n2) {
        this.pixels = nArray;
        this.width = n;
        this.height = n2;
        this.color = -16777216;
        this.depth = new double[nArray.length];
        Arrays.fill(this.depth, Double.POSITIVE_INFINITY);
        Arrays.fill(nArray, -16777088);
        this.V = Transform.IDENTITY;
        this.M = Transform.IDENTITY;
        this.P = Transform.IDENTITY;
        this.Vf = Transform.IDENTITY;
    }

    public Color getColor() {
        return Color.white;
    }

    public Transform getModelTransform() {
        return this.M;
    }

    public Transform getViewTransform() {
        return this.V;
    }

    public Transform getProjectionTransform() {
        return this.P;
    }

    public Transform getViewFrameTransform() {
        return this.Vf;
    }

    public LightModel setLighting() {
        return this.lighting;
    }

    public void setColor(Color color) {
    }

    public void setModelTransform(Transform transform) {
        this.M = transform;
    }

    public void setViewTransform(Transform transform) {
        this.V = transform;
    }

    public void setProjectionTransform(Transform transform) {
        this.P = transform;
    }

    public void setViewFrameTransform(Transform transform) {
        this.Vf = transform;
    }

    public void setLighting(LightModel lightModel) {
        this.lighting = lightModel;
    }

    public void drawPolygon(Point[] pointArray, Vector vector) {
        int n = this.lighting.colorFor(this.M.transform(pointArray[0]), this.M.transform(vector));
        Point[] pointArray2 = new Point[pointArray.length];
        int[] nArray = new int[pointArray.length];
        int[] nArray2 = new int[pointArray.length];
        for (int i = 0; i < pointArray.length; ++i) {
            pointArray2[i] = this.sendThroughPipeline(pointArray[i]);
            nArray[i] = (int)pointArray2[i].getX();
            nArray2[i] = (int)pointArray2[i].getY();
        }
        int[] nArray3 = new int[nArray.length];
        int[] nArray4 = new int[nArray2.length];
        int n2 = this.width;
        int n3 = 0;
        int n4 = this.height;
        int n5 = 0;
        int n6 = nArray[nArray.length - 1];
        int n7 = nArray2[nArray2.length - 1];
        for (int i = 0; i < nArray.length; ++i) {
            int n8 = nArray[i];
            if (n8 < n2) {
                n2 = n8;
            }
            if (n8 > n3) {
                n3 = n8;
            }
            nArray3[i] = n6 - n8;
            n6 = n8;
            int n9 = nArray2[i];
            if (n9 < n4) {
                n4 = n9;
            }
            if (n9 > n5) {
                n5 = n9;
            }
            nArray4[i] = n7 - n9;
            n7 = n9;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n3 >= this.width - 1) {
            n3 = this.width - 1;
        }
        if (n4 < 0) {
            n4 = 0;
        }
        if (n5 >= this.height - 1) {
            n5 = this.height - 1;
        }
        Vector vector2 = pointArray2[1].subtract(pointArray2[0]).cross(pointArray2[2].subtract(pointArray2[0])).normalize();
        vector2 = vector2.scale(1.0 / vector2.getZ());
        double d = -vector2.dot(pointArray2[0].subtract(Point.ORIGIN));
        for (int i = n2; i <= n3; ++i) {
            for (int j = n4; j <= n5; ++j) {
                int n10;
                boolean bl = true;
                boolean bl2 = (i - nArray[0]) * nArray4[0] - (j - nArray2[0]) * nArray3[0] > 0;
                for (n10 = 1; n10 < nArray.length; ++n10) {
                    boolean bl3;
                    boolean bl4 = bl3 = (i - nArray[n10]) * nArray4[n10] - (j - nArray2[n10]) * nArray3[n10] > 0;
                    if (bl2 == bl3) continue;
                    bl = false;
                    break;
                }
                if (!bl) continue;
                n10 = j * this.width + i;
                double d2 = -(d + vector2.getX() * (double)i + vector2.getY() * (double)j);
                if (!(d2 < this.depth[n10])) continue;
                this.depth[n10] = d2;
                this.pixels[n10] = n;
            }
        }
    }

    private Point sendThroughPipeline(Point point) {
        point = this.M.transform(point);
        point = this.V.transform(point);
        point = this.P.transform(point);
        double d = 1.0 / point.getHomogeneous();
        point = Point.create(point.getX() * d, point.getY() * d, point.getZ() * d);
        point = this.Vf.transform(point);
        return point;
    }
}

