/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;

public class LightModel {
    private double ambient = 1.0;
    private ArrayList<Directional> dirs = new ArrayList();

    public void setAmbientIntensity(double d) {
        this.ambient = d;
    }

    public void addDirectional(Vector vector, double d) {
        this.dirs.add(new Directional(vector.normalize(), d));
    }

    public int colorFor(Point point, Vector vector) {
        int n;
        vector = vector.normalize();
        double d = this.ambient;
        for (Directional directional : this.dirs) {
            double d2 = directional.dir.dot(vector);
            if (!(d2 > 0.0)) continue;
            d += directional.intensity * d2;
        }
        int n2 = n = d > 1.0 ? 255 : (int)(255.0 * d);
        if (n < 0) {
            n = 0;
        }
        return 0xFF000000 | n << 16 | n << 8 | n;
    }

    private static class Directional {
        Vector dir;
        double intensity;

        Directional(Vector vector, double d) {
            this.dir = vector;
            this.intensity = d;
        }
    }
}

