/*
 * Decompiled with CFR 0.152.
 */
import java.text.DecimalFormat;

public class Transform {
    public static final Transform IDENTITY = new Transform(new double[]{1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0});
    private static DecimalFormat form = new DecimalFormat("#0.00");
    private static final int SIZE = 4;
    private double[] data;

    private Transform(double[] dArray) {
        this.data = dArray;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("^");
        for (int i = 0; i < this.data.length; ++i) {
            if (i % 4 == 0) {
                if (i > 0) {
                    stringBuffer.append("]\n ");
                }
                stringBuffer.append("[");
            } else {
                stringBuffer.append(",");
            }
            stringBuffer.append(form.format(this.data[i]));
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public Transform append(Transform transform) {
        double[] dArray = new double[16];
        for (int i = 0; i < dArray.length; ++i) {
            double d = 0.0;
            int n = i / 4 * 4;
            for (int j = i % 4; j < 16; j += 4) {
                d += this.data[n] * transform.data[j];
                ++n;
            }
            dArray[i] = d;
        }
        return new Transform(dArray);
    }

    public Transform prepend(Transform transform) {
        return transform.append(this);
    }

    public Point transform(Point point) {
        double d = point.getX();
        double d2 = point.getY();
        double d3 = point.getZ();
        double d4 = point.getHomogeneous();
        double d5 = this.data[0] * d + this.data[1] * d2 + this.data[2] * d3 + this.data[3] * d4;
        double d6 = this.data[4] * d + this.data[5] * d2 + this.data[6] * d3 + this.data[7] * d4;
        double d7 = this.data[8] * d + this.data[9] * d2 + this.data[10] * d3 + this.data[11] * d4;
        double d8 = this.data[12] * d + this.data[13] * d2 + this.data[14] * d3 + this.data[15] * d4;
        return Point.create(d5, d6, d7, d8);
    }

    public Vector transform(Vector vector) {
        double d = vector.getX();
        double d2 = vector.getY();
        double d3 = vector.getZ();
        double d4 = this.data[0] * d + this.data[1] * d2 + this.data[2] * d3;
        double d5 = this.data[4] * d + this.data[5] * d2 + this.data[6] * d3;
        double d6 = this.data[8] * d + this.data[9] * d2 + this.data[10] * d3;
        return Vector.create(d4, d5, d6);
    }

    public static Transform create(double[] dArray) {
        return new Transform(dArray);
    }

    public static Transform translate(double d, double d2, double d3) {
        return new Transform(new double[]{1.0, 0.0, 0.0, d, 0.0, 1.0, 0.0, d2, 0.0, 0.0, 1.0, d3, 0.0, 0.0, 0.0, 1.0});
    }

    public static Transform scale(double d, double d2, double d3) {
        return new Transform(new double[]{d, 0.0, 0.0, 0.0, 0.0, d2, 0.0, 0.0, 0.0, 0.0, d3, 0.0, 0.0, 0.0, 0.0, 1.0});
    }

    public static Transform rotateX(double d) {
        double d2 = Math.cos(d);
        double d3 = Math.sin(d);
        return new Transform(new double[]{1.0, 0.0, 0.0, 0.0, 0.0, d2, -d3, 0.0, 0.0, d3, d2, 0.0, 0.0, 0.0, 0.0, 1.0});
    }

    public static Transform rotateY(double d) {
        double d2 = Math.cos(d);
        double d3 = Math.sin(d);
        return new Transform(new double[]{d2, 0.0, d3, 0.0, 0.0, 1.0, 0.0, 0.0, -d3, 0.0, d2, 0.0, 0.0, 0.0, 0.0, 1.0});
    }

    public static Transform rotateZ(double d) {
        double d2 = Math.cos(d);
        double d3 = Math.sin(d);
        return new Transform(new double[]{d2, -d3, 0.0, 0.0, d3, d2, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0});
    }
}

