import java.awt.*;
import java.awt.event.*;
import java.awt.image.*;
import javax.swing.*;
import java.util.Arrays;
import java.util.Iterator;

/** Maintains a canvas whose contents are unmanaged, but which
 * has an underlying array that can be used to modify the
 * contents directly. */
public class Canvas extends JPanel {
	private class Helper implements ComponentListener {
		public void componentHidden(ComponentEvent e) { }
		public void componentMoved(ComponentEvent e) { }
		public void componentShown(ComponentEvent e) { }
		public synchronized void componentResized(ComponentEvent e) {
			Dimension newSize = getSize();
			if(!newSize.equals(size)) {
				size = newSize;
				img = null;
				pixels_filled = false;
				notifyAll();
			}
		}
	}

	private Dimension size;
	private boolean pixels_filled;
	private int[] pixels;
	private MemoryImageSource producer;
	private Image img;

	public Canvas() {
		size = null;
		pixels_filled = false;
		img = null;

		Helper helper = new Helper();
		addComponentListener(helper);
	}

	public int[] getPixels() {
		ensureImageExists();
		return pixels;
	}

	public void newPixels(int[] pixels) {
		if(pixels == this.pixels) {
			producer.newPixels();
		}
	}

	private synchronized void ensureImageExists() {
		if(img == null) {
			if(size == null) size = getSize();
			pixels = new int[size.height * size.width];
			producer = new MemoryImageSource(size.width, size.height,
				pixels, 0, size.width);
			producer.setAnimated(true);
			img = createImage(producer);
		}
	}

	public void paintComponent(Graphics g) {
		super.paintComponent(g);
		ensureImageExists();
		g.drawImage(img, 0, 0, this);
	}
}
