import java.awt.Graphics;
import java.awt.Color;
import java.util.Arrays;

public class Graphics3D {
	private int[] pixels;
	private int width;
	private int height;
	private int color;
	private LightModel lighting;
	private Transform M;   // model transform
	private Transform V;   // view transform
	private Transform P;   // perspective transform
	private Transform Vf;  // view frame transform

	public Graphics3D(int[] pixels, int width, int height) {
		this.pixels = pixels;
		this.width = width;
		this.height = height;
		this.color = 0xFF000000;

		Arrays.fill(pixels, 0xFF000080);

		V = Transform.IDENTITY;
		M = Transform.IDENTITY;
		P = Transform.IDENTITY;
		Vf = Transform.IDENTITY;
	}

	public Color getColor() { return Color.white; }
	public Transform getModelTransform() { return M; }
	public Transform getViewTransform() { return V; }
	public Transform getProjectionTransform() { return P; }
	public Transform getViewFrameTransform() { return Vf; }
	public LightModel setLighting() { return lighting; }

	public void setColor(Color c) { }
	public void setModelTransform(Transform t) { M = t; }
	public void setViewTransform(Transform t) { V = t; }
	public void setProjectionTransform(Transform t) { P = t; }
	public void setViewFrameTransform(Transform t) { Vf = t; }
	public void setLighting(LightModel l) { lighting = l; }

	public void drawPolygon(Point[] polygonPts, Vector normal) {
		// compute screen coordinates for each point
		Point[] screenPts = new Point[polygonPts.length];
		int[] sx = new int[polygonPts.length];
		int[] sy = new int[polygonPts.length];
		for(int i = 0; i < polygonPts.length; i++) {
			screenPts[i] = sendThroughPipeline(polygonPts[i]);
			sx[i] = (int) screenPts[i].getX();
			sy[i] = (int) screenPts[i].getY();
		}

		// determine color
		int color = lighting.colorFor(M.transform(polygonPts[0]),
				M.transform(normal));
		// For Part I, I recommend that you insert this line so
		// that everything is painted white. The result will be
		// that you see a silhouette only. You will want to
		// remove it for Part II, though.
		//  color = 0xFFFFFFFF;

		// your code will go here.
	}

	/** Returns the result of feeding the given point through
	 * the graphics pipeline. */
	private Point sendThroughPipeline(Point p) {
		p = M.transform(p);
		p = V.transform(p);
		p = P.transform(p);
		double s = 1.0 / p.getHomogeneous();
		p = Point.create(p.getX() * s, p.getY() * s, p.getZ() * s);
		p = Vf.transform(p);
		return p;
	}
}
