import java.util.ArrayList;

public class LightModel {
	private static class Directional {
		Vector dir;
		double intensity;

		Directional(Vector d, double i) { dir = d; intensity = i; }
	}

	private double ambient = 1.0;
	private ArrayList<Directional> dirs = new ArrayList<Directional>();

	public LightModel() { }

	public void setAmbientIntensity(double a) {
		ambient = a;
	}

	public void addDirectional(Vector dir, double intensity) {
		dirs.add(new Directional(dir.normalize(), intensity));
	}

	public int colorFor(Point p, Vector n) {
		n = n.normalize();
		double total = ambient;
		for(Directional d : dirs) {
			double light = d.dir.dot(n);
			if(light > 0) total += d.intensity * light;
		}
		int i = (total > 1.0 ? 255 : (int) (255 * total));
		if(i < 0) i = 0;
		return 0xFF000000 | (i << 16) | (i << 8) | i;
	}
}
