import java.awt.Graphics;
import java.awt.Color;

public class Polygon extends Model {
	private Point[] pts;
	private Vector norm;

	public Polygon(Point[] points) {
		pts = new Point[points.length];
		System.arraycopy(points, 0, pts, 0, pts.length);

		norm = normalBetween(points.length - 2, points.length - 1, 0)
			.add(normalBetween(points.length - 1, 0, 1));
		for(int i = 2; i < points.length; i++) {
			norm = norm.add(normalBetween(i - 2, i - 1, i));
		}
		norm = norm.normalize();
	}

	private Vector normalBetween(int i0, int i1, int i2) {
		return pts[i2].subtract(pts[i1])
			.cross(pts[i0].subtract(pts[i1]));
	}

	public void draw(Graphics3D g) {
		g.drawPolygon(pts, norm);
	}
}
