/** Partial implementation of Intersection interface. */
public abstract class AbstractIntersection extends Intersection {
	private Ray incident;
	private double distance;
	private Point hit = null;

	public AbstractIntersection(Ray incident, double distance) {
		this.incident = incident;
		this.distance = distance;
	}

	public double getDistance() { return distance; }
	public Ray getIncidentRay() { return incident; }
	public Point getHitPoint() {
		if(hit == null) hit = incident.getOrigin().addScaled(distance, incident.getDirection());
		return hit;
	}

	public abstract Vector getNormal();
}
