import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.util.Arrays;

/** Manages a window containing a scene. */
public class ModelViewer extends JFrame {
	private class Canv extends Canvas {
		public Canv() {
			setBackground(java.awt.Color.WHITE);
			setPreferredSize(new Dimension(200, 200));
		}

		public void paintComponent(Graphics g) {
			super.paintComponent(g);

			Dimension d = getSize();
			int[] pixels = getPixels();
			Arrays.fill(pixels, 0xFFFFFFFF);
			renderer.setPixels(pixels, d.width, d.height);
			renderer.render(scene);
			newPixels(pixels);
		}
	}

	private class WindowCloser extends WindowAdapter {
		public void windowClosing(WindowEvent e) { System.exit(0); }
	}

	private Canv canvas = new Canv();
	private Renderer renderer = new Renderer();
	private Scene scene = new Scene();

	public ModelViewer() {
		setTitle("Model Viewer");
		addWindowListener(new WindowCloser());

		getContentPane().add(canvas);
		pack();
	}

	public Renderer getRenderer() { return renderer; }
	public Scene getScene() { return scene; }

	public void setScene(Scene scene) {
		this.scene = scene;
	}

	public void addKeyListener(KeyListener l) { canvas.addKeyListener(l); }
	public void removeKeyListener(KeyListener l) { canvas.removeKeyListener(l); }
	public void addFocusListener(FocusListener l) { canvas.addFocusListener(l); }
	public void removeFocusListener(FocusListener l) { canvas.removeFocusListener(l); }
	public void grabFocus() { canvas.grabFocus(); }

}
