/** Represents a ray in three-dimensional coordinates, including
 * an originating point and a direction vector. */
public class Ray {
	private Point origin;
	private Vector direction;

	private Ray(Point origin, Vector direction) {
		this.origin = origin;
		this.direction = direction;
	}

	/** Returns the originating point of this ray. */
	public Point getOrigin() { return origin; }

	/** Returns the direction of this ray. */
	public Vector getDirection() { return direction; }

	/** Returns the point along the ray where the direction,
	 * scaled by the given multiplier, has been added to the
	 * originating point. */
	public Point extend(double multiplier) {
		return origin.addScaled(multiplier, direction);
	}

	/** Creates a ray with the given originating point and
	 * direction. */
	public static Ray create(Point origin, Vector direction) {
		return new Ray(origin, direction);
	}
}
