/** Represents an abstract surface in the scene. */
public abstract class Surface {
	public static final Surface EMPTY = new Empty();

	private static class Empty extends Surface {
		public Intersection getIntersection(Ray query) { return Intersection.NONE; }
	}

	public Surface() { }

	/** Returns information about the closest point on this
	 * surface that the query ray hits, where the ``distance''
	 * along the ray will be at least one. */
	public abstract Intersection getIntersection(Ray query);
}
