#include <math.h>
#include <GL/glut.h>
#include "wheel.h"
#include "wagon.h"

// Initializes data necessary for drawing a wagon.
void wagonInit() {
	wheelInit();
}

// Draws wagon with wheels' bottom on the x-axis, with front at
// origin (0,0) and rear at (1,0). The parameter, expressed in
// radians, indicates the rotation of the wheels.
void wagonDraw(double wheel_theta) {
	glBegin(GL_POLYGON);			// Draw wagon bed.
		glVertex2f(1.0, 0.12);
		glVertex2f(1.0, 0.3);
		glVertex2f(0.0, 0.3);
		glVertex2f(0.0, 0.12);
	glEnd();

	glBegin(GL_LINES);
		glVertex2f(0.13, 0.35);		// Draw bench.
		glVertex2f(0.21, 0.35);
		glVertex2f(0.20, 0.30);		// Draw bench back.
		glVertex2f(0.24, 0.50);
	glEnd();

	glPushMatrix();					// Draw front wheel.
	glTranslatef(0.15, 0.1, 0);
	glScalef(0.1, 0.1, 0.1);
	glRotatef(wheel_theta * 180 / M_PI, 0.0, 0.0, 1.0);
	wheelDraw();
	glPopMatrix();

	glPushMatrix();					// Draw rear wheel.
	glTranslatef(0.8, 0.1, 0);
	glScalef(0.1, 0.1, 0.1);
	glRotatef(wheel_theta * 180 / M_PI, 0.0, 0.0, 1.0);
	wheelDraw();
	glPopMatrix();
}
