#include <GL/glut.h>
#include "wagon.h"

// Initializes information for drawing within OpenGL.
void init() {
	glClearColor(1.0, 1.0, 1.0, 0.0);	// Set window color to white.
	glMatrixMode(GL_PROJECTION);		// Set projection parameters.
	gluOrtho2D(-.25, 1.25, -.25, 0.75);	// Set viewable coordinates.
	wagonInit();
}

// Draws the image.
void draw() {
	glClear(GL_COLOR_BUFFER_BIT);		// Clear display window.

	glColor3f(0.0, 0.0, 0.0);			// Set drawing color to black.
	wagonDraw(0.0);

	glFlush();	// Process all OpenGL routines as quickly as possible.
}

int main(int argc, char **argv) {
	glutInit(&argc, argv);
	glutInitDisplayMode(GLUT_SINGLE | GLUT_RGB);
	glutInitWindowPosition(50, 100);	// Set up display window.
	glutInitWindowSize(300, 200);
	glutCreateWindow("Still Wagon");

	init();
	glutDisplayFunc(draw);
	glutMainLoop();
	return 0;
}

// To compile: gcc wagon_main.c wagon.c wheel.c -lglut -lGLU -lGL -lm
