#include <stdlib.h>
#include <math.h>
#include <GL/glut.h>
#include "wheel.h"

#define WAGON_RIM_N   24
#define WAGON_SPOKE_N 12

static double *spoke_pts = NULL;
static double *rim_pts;

// Creates an array of 2*n doubles representing n points evenly
// spaced around a circle of radius 1. Point i on the
// circumference will be at coordinates (array[2*i], array[2*i+1]).
static double* createCircumferencePoints(int n) {
	double *ret;
	int i;
	double theta;
	
	ret = (double*) malloc(2 * n * sizeof(double));
	for(i = 0; i < n; i++) {
		theta = 2 * M_PI * i / n;
		ret[2 * i]     = cos(theta);
		ret[2 * i + 1] = sin(theta);
	}
	return ret;
}

// Initializes data necessary for drawing a wagon wheel.
void wheelInit() {
	if(spoke_pts == NULL) {
		spoke_pts = createCircumferencePoints(WAGON_SPOKE_N);
		rim_pts   = createCircumferencePoints(WAGON_RIM_N);
	}
}

// Draws wagon wheel of radius 1, centered at origin.
void wheelDraw() {
	int i;

	glBegin(GL_LINES);					// Draw spokes.
	for(i = 0; i < WAGON_SPOKE_N; i++) {
		glVertex2f(0.0, 0.0);
		glVertex2f(spoke_pts[2 * i], spoke_pts[2 * i + 1]);
	}
	glEnd();

	glBegin(GL_LINE_LOOP);				// Draw rim.
	for(i = 0; i < WAGON_RIM_N; i++) {
		glVertex2f(rim_pts[2 * i], rim_pts[2 * i + 1]);
	}
	glEnd();
}
