#include <GL/glut.h>
#include "wheel.h"

// Initializes information for drawing within OpenGL.
void init() {
	glClearColor(1.0, 1.0, 1.0, 0.0);	// Set window color to white.
	glMatrixMode(GL_PROJECTION);		// Set projection parameters.
	gluOrtho2D(-1.5, 1.5, -1.5, 1.5);	// Set viewable coordinates
	wheelInit();
}

// Draws the picture.
void draw() {
	glClear(GL_COLOR_BUFFER_BIT);	// Clear display window.

	glColor3f(0.0, 0.0, 0.0);		// Set line segment color to black.
	wheelDraw();

	glFlush();	// Process all OpenGL routines as quickly as possible.
}

int main(int argc, char **argv) {
	glutInit(&argc, argv);
	glutInitDisplayMode(GLUT_SINGLE | GLUT_RGB);
	glutInitWindowPosition(50, 100);	// Set up display window.
	glutInitWindowSize(200, 200);
	glutCreateWindow("Wagon Wheel");

	init();
	glutDisplayFunc(draw);
	glutMainLoop();
	return 0;
}

// To compile: gcc wheel_main.c wheel.c -lglut -lGLU -lGL -lm
