#include <stdio.h>
#include <GL/glut.h>
#include <math.h>
#include "wagon.h"

#define MOVEMENT_RATE 0.0002

// Initializes information for drawing within OpenGL.
void init() {
	glClearColor(1.0, 1.0, 1.0, 0.0);	// Set window color to white.
	glMatrixMode(GL_PROJECTION);		// Set projection parameters.
	gluOrtho2D(0.0, 3.0, -.25, .75);	// Set viewable coordinates.
	wagonInit();
}

// Draw a wagon that has traveled across the window the given distance.
void drawWagonAt(double dist) {
	glPushMatrix();
	glTranslatef(3.0 - dist, 0.0, 0.0);
	wagonDraw(dist / 0.1);
	glPopMatrix();
}

// Draws the current image.
void draw() {
	// Compute how far the youngest wagon on-screen has traveled.
	double offs = fmod(MOVEMENT_RATE * glutGet(GLUT_ELAPSED_TIME), 1.5);

	glClear(GL_COLOR_BUFFER_BIT);	// Clear display window.

	glColor3f(0.0, 0.0, 0.0);
	drawWagonAt(offs);				// Draw the wagons. (Up to three
	drawWagonAt(offs + 1.5);		// may be on-screen at once.)
	drawWagonAt(offs + 3.0);	

	glFlush();	// Process all OpenGL routines as quickly as possible.
}

// Arranges that the window will be redrawn roughly every 40 ms.
void idle() {
	static int lastTime = 0;				// time of last redraw
	int time = glutGet(GLUT_ELAPSED_TIME);	// current time

	if(lastTime == 0 || time >= lastTime + 40) {
		lastTime = time;
		glutPostRedisplay();
	}
}

// When window becomes visible, we want the window to
// continuously repaint itself.
void visible(int vis) {
	glutIdleFunc(vis == GLUT_VISIBLE ? idle : NULL);
}

int main(int argc, char **argv) {
	glutInit(&argc, argv);
	glutInitDisplayMode(GLUT_SINGLE | GLUT_RGB);
	glutInitWindowPosition(50, 100);	// Set up display window.
	glutInitWindowSize(450, 150);
	glutCreateWindow("Moving Wagon");

	init();
	glutDisplayFunc(draw);
	glutVisibilityFunc(visible);
	glutMainLoop();
	return 0;
}

// To compile: gcc moving_main.c wagon.c wheel.c -lglut -lGLU -lGL -lm
