#include <math.h>
#include <GL/glut.h>
#include "wheel.h"
#include "wagon.h"

// Initializes data necessary for drawing a wagon.
void wagonInit() {
	wheelInit();
}

void drawAlignedRectangle(double x0, double x1, double y0, double y1,
		double z0, double z1) {
	glPushMatrix();						// Draw wagon bed.
	glTranslatef((x0 + x1) / 2, (y0 + y1) / 2, (z0 + z1) / 2);
	glScalef(x1 - x0, y1 - y0, z1 - z0);
	glutSolidCube(1.0);
	glPopMatrix();
}

// Draws wagon with wheels' bottom on the x-axis, with front at
// origin (0,0) and rear at (1,0). The parameter, expressed in
// radians, indicates the rotation of the wheels.
void wagonDraw(double wheel_theta) {
	int i;
	double x, z;

	glColor3f(1.0, 0.0, 0.0);			// Draw red wagon bed.
	drawAlignedRectangle(0.0, 1.0, 0.12, 0.13, -.24, 0.24);
	drawAlignedRectangle(0.0, 1.0, 0.13, 0.25, -.24, -.23);
	drawAlignedRectangle(0.0, 1.0, 0.13, 0.25, 0.23, 0.24);
	drawAlignedRectangle(0.0, .01, 0.13, 0.25, -.23, 0.23);

	glColor3f(0.7, 0.6, 0.0);			// Draw brown wagon bench.
	drawAlignedRectangle(0.13, 0.25, 0.27, 0.28, -.23, 0.23); // bench
	drawAlignedRectangle(0.24, 0.25, 0.28, 0.45, -.23, 0.23); // back

	glColor3f(0.0, 0.0, 0.0);			// Switch to black.
	glBegin(GL_LINES);
		glVertex3f(0.15, 0.1, -.25);	// Draw front and rear axles
		glVertex3f(0.15, 0.1, 0.25);
		glVertex3f(0.80, 0.1, -.25);
		glVertex3f(0.80, 0.1, 0.25);
		glVertex3f(0.20, 0.13, -.15);	// Draw bench legs
		glVertex3f(0.20, 0.27, -.15);
		glVertex3f(0.20, 0.13, 0.15);
		glVertex3f(0.20, 0.27, 0.15);
	glEnd();

	for(i = 0; i < 4; i++) {			// Draw the four wheels.
		x = (i % 2 == 0 ? 0.15 : 0.80); 	// (front or rear?)
		z = (i / 2 == 0 ? 0.25 : -.25); 	// (left or right?)
		glPushMatrix();
		glTranslatef(x, 0.1, z);
		glScalef(0.1, 0.1, 0.1);
		glRotatef(wheel_theta * 180 / M_PI, 0.0, 0.0, 1.0);
		wheelDraw();
		glPopMatrix();
	}
}
