#include <stdio.h>
#include <GL/glut.h>
#include <math.h>
#include "wagon.h"

#define MOVEMENT_RATE 0.0002


// Initializes information for drawing within OpenGL.
void init() {
	GLfloat sun_direction[] = { 0.0, 2.0, -1.0, 0.0 };
	GLfloat half_intensity[] = { 0.5, 0.5, 0.5, 1.0 };
	double sinth = sin(0.15); // we're 0.15 radians from horizontal
	double costh = cos(0.15);

	glClearColor(0.5, 1.0, 0.5, 0.0);	// Set window color to green.

	glMatrixMode(GL_PROJECTION);		// Set projection parameters.
	glLoadIdentity();
//	glOrtho(-1.5, 1.5, -0.5, 0.5, 1, 3);
	glFrustum(-0.75, 0.75, -.25, 0.25, 1.0, 3.0);
	gluLookAt(1.5, 2 * sinth + 0.25, -2 * costh,	// (my location)
			1.5, 0.25, 0,							// (where I face)
			0, costh, sinth);						// (up direction)

	glEnable(GL_DEPTH_TEST);			// Draw only closest surfaces

	glEnable(GL_LIGHTING);				// Set up ambient light.
	glLightModelfv(GL_LIGHT_MODEL_AMBIENT, half_intensity);

	glEnable(GL_LIGHT0);				// Set up sunlight.
	glLightfv(GL_LIGHT0, GL_POSITION, sun_direction);
	glLightfv(GL_LIGHT0, GL_DIFFUSE, half_intensity);

	glEnable(GL_COLOR_MATERIAL);		// Configure glColor().
	glColorMaterial(GL_FRONT, GL_AMBIENT_AND_DIFFUSE);

	wagonInit();
}

// Draw a wagon that has traveled across the window the given distance.
void drawWagonAt(double dist) {
	glPushMatrix();
	glTranslatef(3.0 - dist, 0.0, 0.0);
	wagonDraw(dist / 0.1);
	glPopMatrix();
}

// Draws the current image.
void draw() {
	// Compute how far the youngest wagon on-screen has traveled.
	double offs = fmod(MOVEMENT_RATE * glutGet(GLUT_ELAPSED_TIME), 1.5);

	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);	// Clear window.

	drawWagonAt(offs - 0.3);		// Draw the wagons. (Up to three
	drawWagonAt(offs + 1.2);		// may be on-screen at once.)
	drawWagonAt(offs + 2.7);	

	glFlush();	// Process all OpenGL routines as quickly as possible.
}

// Arranges that the window will be redrawn roughly every 40 ms.
void idle() {
	static int lastTime = 0;				// time of last redraw
	int time = glutGet(GLUT_ELAPSED_TIME);	// current time

	if(lastTime == 0 || time >= lastTime + 40) {
		lastTime = time;
		glutPostRedisplay();
	}
}

// When window becomes visible, we want the window to
// continuously repaint itself.
void visible(int vis) {
	glutIdleFunc(vis == GLUT_VISIBLE ? idle : NULL);
}

int main(int argc, char **argv) {
	glutInit(&argc, argv);
	glutInitDisplayMode(GLUT_DEPTH | GLUT_SINGLE | GLUT_RGB);
	glutInitWindowPosition(50, 100);	// Set up display window.
	glutInitWindowSize(450, 150);
	glutCreateWindow("3D Wagon Train");

	init();
	glutDisplayFunc(draw);
	glutVisibilityFunc(visible);
	glutMainLoop();
	return 0;
}

// To compile: gcc moving_main.c wagon.c wheel.c -lglut -lGLU -lGL -lm
