package csbsju.cs160;

/** Represents an expandable array of objects. The elements are
 * indexed beginning at 0 and going up. The size of the array is
 * initially 0, but it will grow as you call <code>add()</code>. */
public class ArrayList {
	java.util.ArrayList vec = new java.util.ArrayList();

	/** Creates an empty vector. */
	public ArrayList() { }

	/** Returns the number of elements in the array. */
	public int size() { return vec.size(); }

	/** Returns the element at index <code>index</code> in the
	 * array. Note that <code>index</index> must be at least 0 and less
	 * than <code>size()</code>. */
	public Object get(int index) { return vec.get(index); }

	/** Adds the object <code>obj</code> to the end of the array. */
	public void add(Object obj) { vec.add(obj); }

	/** Adds the object <code>obj</code> at index <code>index</code> in
	 * the array. Elements are shifted up to accommodate. */
	public void add(int index, Object obj) { vec.add(index, obj); }

	/** Replaces the object stored at index <code>index</code> with
	 * <code>obj</code>, returning the previous value at the index.
	 * The old object simply disappears from the
	 * array. Note that <code>index</index> must be at least 0 and less
	 * than <code>size()</code>. */
	public Object set(int index, Object obj) { return vec.set(index, obj); }

	/** Removes the object at location <code>index</code> in the array,
	 * returning the removed object.
	 * Any elements beyond this are shifted downward to fill the gap. */
	public Object remove(int index) { return vec.remove(index); }

	/** Clears the array of all elements. */
	public void clear() { vec.clear(); }

	/** Returns the index of the first occurrence of <code>obj</code> in
	 * the array, or -1 if no match is found. The object's
	 * <code>equals()</code> method is used to
	 * determine when it finds a match. */
	public int indexOf(Object obj) { return vec.indexOf(obj); }
}
